/**********************************************************************
 Copyright (c), 1991-2010, T&W ELECTRONICS(SHENTHEN) Co., Ltd.
 File Name : mtr.h
 Author: Zhao Yanming   Version: V1.0    Date: september 21, 2010
 Description : implement traffic meter 

 Function list :

 History :
     1. Date:
        Author:
        Modification:
**********************************************************************/

#ifndef _MTR_H_
#define _MTR_H_

//#define MTR_DEBUG
#ifdef MTR_DEBUG
#define MTR_TRACE(fmt, args...) printf("[%s](%d)=>"fmt, __FUNCTION__, __LINE__,##args)
#else
#define MTR_TRACE(fmt, args...)
#endif

#define MTR_PROC_DEV_FILE              "/proc/net/dev"
#define MTR_WAN_INTERFACE              "eth1"
#define MTR_UPDATA_INTERVAL            0 /* seconds */
#define MTR_SAVE_INTERVAL              15 /* seconds */
#define MTR_SAVE_NAME                  "stt"

#define MTR_ITF_DOWN                   0
#define MTR_ITF_UP                     1

#define OPT_TRAFFC_VLM_CTL             0 /* Traffic volume control by */
#define OPT_CNN_TIME_VTL               1 /* Connection time control */

#define CTL_OPT_NOLIMIT                0
#define CTL_OPT_DOWN_ONLY              1
#define CTL_OPT_BOTH                   2

#define LIMIT_WARNING_VLM_OVER         1 /* VolumeOver */
#define LIMIT_WARNING_TIME_OVER        2 /* TimeOver */
#define LIMIT_WARNING_VLM_LIMIT        3 /* VolumeReachedLimit */
#define LIMIT_WARNING_TIME_LIMIT       4 /* TimeReachedLimit */
#define NEXT_MONTH_RESTART_WAN       5 

#define WARNED_FLAG_OVER               0x01
#define WARNED_FLAG_LIMIT              0x02

#define PATH_WAN_CONN "InternetGatewayDevice.WANDevice.1.WANConnectionDevice.1"

typedef struct tVlmEntry_
{
    unsigned long ulCnnTi;
    unsigned long ulVlmUp;
    unsigned long ulVlmUpAvg;
    unsigned long ulVlmDw;
    unsigned long ulVlmDwAvg;
    unsigned long ulVlmTtl;
    unsigned long ulVlmTtlAvg;    
}
tVlmEntry;

typedef struct tTrffcStt_
{
    unsigned long ulStartTi;
    unsigned long ulLastTi;

    unsigned long ulLastRx;
    unsigned long ulLastTx;

    tVlmEntry tdVlmEnt;         /* Today */
    tVlmEntry ydVlmEnt;         /* Yesterday */
    tVlmEntry wkVlmEnt;         /* This week */
    tVlmEntry mthVlmEnt;        /* This month */
    tVlmEntry lmthVlmEnt;       /* Last month */
}
tTrffcStt;

typedef struct tTrffcMtr_
{
    int iEnable;
    int iItfstate;
    int iTrffcOpt;
    int iTrffcVlmOpt;
    unsigned long ulTvMonLmt;
    unsigned long ulTvRndUp;
    unsigned long ulCtMonLmt;
    unsigned long ulRestartMinute;
    int iRestartedMonth;
    unsigned long ulOver;
    int iDiscnnFlag;
    int iWarnedFlag;
    tTrffcStt trffcStt;
}
tTrffcMtr;

int SendWarningMessage( const unsigned short iType, const int iData );
#endif

